# -*- coding: utf-8 -*-
"""
Created on Thu Mar 27 17:11:24 2025

@author: semik
"""
# LST Code (based on MP Lecture HANK course)

# In[1]:


# Import standard packages
import math
import numpy as np  
import matplotlib.pyplot as plt 
import sequence_jacobian as sj  
from copy import deepcopy
import scipy
import pandas
# Here is our predefined `calibration` dictionary for this session.
# In[2]:
calibration = {'eis': 1,     # EIS
               'rho_e': 0.98,  # Persistence of idiosyncratic productivity shocks
               'sd_e': 0.92,   # Standard deviation of idiosyncratic productivity shocks
               'rho_p': 0.98,  # Persistence of idiosyncratic productivity shocks
               'sd_p': 0.92,   # Standard deviation of idiosyncratic productivity shocks
               'yss': 1,        # Output steady state
               'Y': 1,        # Output
               'X': 1,        
               'r_ante': 0.005, # target real interest rate
               'min_a':-1 ,    # Minimum asset level on the grid
               'max_a': 1000,   #Maximum asset level on the grid
               'n_a': 500,     # Number of asset grid points
               'n_e': 11,       # Number of productivity grid points
               'yshock':0,
               'curve':0.5, 
               'phi':207.6748604782035,                
               'epsilon':11,
               'G': 0.2,  # Government spending
               'B': 2.8,  # Government debt
               'zeta':-4, #Countercyclical income risk
               'zetap':-10, #Countercyclical profit income risk
               }    

print('Calibration done')


# In[3]: 

# initialize
def hh_init(a_grid, z, r, eis,dfshock,p):
    coh = (1 + r) * a_grid[np.newaxis, :] + z[:, np.newaxis]  + p[:, np.newaxis] 
    Va = (1 + r) * (coh) ** (-1 / eis)
    return Va

# backward step
@sj.het(exogenous='Pi',  # <-- this means our transition matrix will be fed into the model as Pi (use this for forward iteration)
        policy='a',  # <-- this means our endogenous state variable is a, defined over grid a_grid (we use this to check convergence)
        backward='Va',  # <-- this means we're iterating over variable Va, whose future value is Va_p (solver needs to know this to iterate!)
        backward_init=hh_init)
def hh(Va_p, a_grid, z, r, beta, eis,dfshock,Y,p):
    uc_nextgrid = beta *2.72**(dfshock)* Va_p  # u'(c') on tomorrow's grid
    c_nextgrid = uc_nextgrid ** (-eis) # c' on tomorrow's grid
    coh = (1 + r) * a_grid[np.newaxis, :] + z[:, np.newaxis] + p[:, np.newaxis] # cash on hand on today's grid
    a = sj.interpolate.interpolate_y(c_nextgrid + a_grid, coh, a_grid)  # this plots (c_next + a', a') pairs and computes policy a' from interpolation on coh
    sj.misc.setmin(a, a_grid[0])  # impose borrowing constraint
    c = coh - a  # back out consumption
    Va = (1 + r) * (c) ** (-1 / eis)  # V'(a)
    return Va, a, c,coh
    

# forward iteration is done automatically!

def income_cyclical(Y,Z,P,T,e_grid, e_pdf, zeta,zetap,markup_ss,p_grid,p_pdf):
    N =Y
    gamma_N = e_grid ** (zeta * np.log(N)) / np.vdot(e_grid ** (1 + zeta * np.log(N)), e_pdf)
    z = Z * e_grid *gamma_N
    pretax = (Y/markup_ss) * e_grid *gamma_N
    #gamma_P = p_grid ** (zetap * np.log(P/((1-T)*(1-1/markup_ss)))) / np.vdot(p_grid ** (1 + zetap * np.log(P/((1-T)*(1-1/markup_ss)))), p_pdf)
    gamma_P = p_grid ** (zetap * np.log(Y)) / np.vdot(p_grid ** (1 + zetap * np.log(Y)), p_pdf)
    p = (P)* p_grid * gamma_P
    p_pretax = (Y*(1-1/markup_ss))* p_grid * gamma_P
    return z, p, pretax, p_pretax


def make_grids_pdf(rho_e, rho_p, sd_e, sd_p, n_e, min_a, max_a, n_a):
    e_grid, e_pdf, Pi = sj.grids.markov_rouwenhorst(rho_e, sd_e, n_e)
    p_grid, p_pdf, Pi = sj.grids.markov_rouwenhorst(rho_p, sd_p, n_e)
    a_grid = sj.grids.asset_grid(min_a, max_a, n_a)
    return e_grid, e_pdf, Pi, a_grid,  p_grid, p_pdf

household_cyc = hh.add_hetinputs([make_grids_pdf, income_cyclical])

@sj.simple
def ex_post_rate(r_ante):
    r = r_ante
    return r

@sj.simple
def fiscal(B, r, G, Y, Tr,dfshock,markup_ss):
    T = ((1 + r) * B(-1) + G - B + Tr)/(Y) # total tax burden
  
    Z = (Y/markup_ss)*(1 - T)  # after tax income
    P = Y*(1-1/markup_ss)*(1-T)
    deficit = G + Tr - T
    return T, Z, deficit,P

@sj.simple
def mkt_clearing_simple(A, B, Y, C, G):
    asset_mkt = A - B
    goods_mkt = Y - C - G
    return asset_mkt, goods_mkt

ha_simple = sj.create_model([household_cyc, ex_post_rate, mkt_clearing_simple])
ha_cyc = sj.create_model([household_cyc, ex_post_rate, mkt_clearing_simple], name="HA Model with cyclical income risk")

#Economy with MP - variable kappa 

@sj.simple
def nkpc(pi, Y, yss, T, C, Z,theta_w, vphi, frisch, markup_ss, eis, beta, cpshock, curve, epsilon, phi,dfshock):
    kappa_w_base = epsilon/phi
    kappa_w = kappa_w_base*(2.72**(curve*100*(Y-yss)))
    N = Y
    W = 1/markup_ss
    piw = (1+pi) * W / W(-1) -1
    piwres= kappa_w*N*(vphi * (N)**(1/frisch)-(epsilon-1)/epsilon*C**(-1/eis)*W*(1-T)) + beta*2.72**(dfshock)*piw(1)*(1+piw(1)) - piw*(1+piw) + cpshock
    return piwres, piw, kappa_w,N,W



@sj.simple
def monetary_taylor_v(pi, Y,yss,ishock, phi_pi, phi_y,rss): 
    i=((1+rss)*(pi+1)**phi_pi*  (Y/yss)**phi_y)*2.72** ishock -1
    r_ante = (1+i) / (1+pi(1)) -1
    return i, r_ante


# We'll also define an RA model for comparison

#In[7]:


@sj.solved(unknowns={'C': 1, 'A': 1}, targets=["euler", "budget_constraint"], solver="broyden_custom")
def household_ra_simple(C, A, Y, eis, beta, r):
    euler = (beta * (1 + r(1))) ** (-eis) * C(1) - C
    budget_constraint = (1 + r) * A(-1) + Y - C - A
    return euler, budget_constraint

ra = sj.create_model([household_ra_simple, ex_post_rate, mkt_clearing_simple], name="Representative Agent Model")


ss = {}
models = {'ha': ha_simple, 'ra': ra}

print('Model Set-up done')


#%% Cyclical HANK setup

models['ha_taylor_cyc'] = sj.create_model([household_cyc, mkt_clearing_simple, nkpc,
                                        ex_post_rate, monetary_taylor_v,fiscal], name='Cyclical HA w/ Taylor Rule')

calib_taylor_cyc = calibration.copy()
calib_taylor_cyc.update({'rss': calibration['r_ante'], 'pi': 0., 'ishock': 0.,
                            'phi_pi': 1.5,'phi_y':0.2, 'theta_w': 0.85, 'frisch': 0.5, 'markup_ss': 1.2, 'dfshock':0,'cpshock':0, 'Tr':0.})

ss['ha_taylor_cyc'] = models['ha_taylor_cyc'].solve_steady_state(calib_taylor_cyc, {'beta': 0.99, 'vphi': 0.8}, ['asset_mkt', 'piwres'])


#%% Create storage !! Only run the first time!! Otherwise results will be overwritten!!
irf_i_ha, G_ha, irf_Y_ha, irf_r_post_ha, irf_pi_ha, irf_kappa_ha, irf_internals, irf_internals_D , irf_internals_a, irf_internals_y, irf_internals_p,irf_internals_pre,irf_internals_p_pre= {}, {}, {}, {},{},{},{},{},{},{},{},{},{}


#%% Supply Shock in HANK 

import copy
irf_i_ha['dfshock'],irf_Y_ha['dfshock'], irf_r_post_ha['dfshock'],  irf_pi_ha['dfshock'], irf_kappa_ha['dfshock'], irf_internals['dfshock'],irf_internals_D['dfshock'],irf_internals_a['dfshock'],irf_internals_y['dfshock'], irf_internals_p['dfshock'],irf_internals_pre['dfshock'],irf_internals_p_pre['dfshock'] = {},{},{},{},{},{},{},{},{},{},{},{}
T=100
df_shock_list=[0.002, 0.0006, -0.0006, -0.002]
df_shock_test=[0]
ddf=df_shock_test * 0.9 ** np.arange(T)
piguess=ddf*0;
Yguess=ddf*0;

for i, df_shock in enumerate(df_shock_list): 
    ddf = df_shock * 0.9 ** np.arange(T)
    calibration_theta = copy.deepcopy(calib_taylor_cyc)
    ss_nom_ha = models['ha_taylor_cyc'].solve_steady_state( calibration_theta, { 'beta': 0.99, 'vphi': 0.8}, ['asset_mkt', 'piwres'])
    irf_here_ha = models['ha_taylor_cyc'].solve_impulse_nonlinear(ss_nom_ha, ['Y', 'pi'], ['asset_mkt', 'piwres'], {'cpshock': ddf},internals=['hh'] )
    piguess=irf_here_ha['pi'];  
    Yguess=irf_here_ha['Y']; 
    irf_i_ha['dfshock'][i], irf_Y_ha['dfshock'][i], irf_r_post_ha['dfshock'][i] , irf_pi_ha['dfshock'][i], irf_kappa_ha['dfshock'][i], irf_internals['dfshock'][i],irf_internals_D['dfshock'][i],irf_internals_a['dfshock'][i],irf_internals_y['dfshock'][i],irf_internals_p['dfshock'][i],irf_internals_pre['dfshock'][i],irf_internals_p_pre['dfshock'][i] =irf_here_ha["i"], irf_here_ha["Y"], irf_here_ha["r_ante"], irf_here_ha["pi"], irf_here_ha["kappa_w"], irf_here_ha.internals['hh']['c'] , irf_here_ha.internals['hh']['D'] , irf_here_ha.internals['hh']['a'], irf_here_ha.internals['hh']['z'] ,irf_here_ha.internals['hh']['p'],irf_here_ha.internals['hh']['pretax'],irf_here_ha.internals['hh']['p_pretax']
    print('Shock Number '+ str(i+1) )
    


#%% Income Inequality 
stdlog_nonlin_inc_tot, stdlog_nonlin_inc, stdlog_nonlin_inc_tot_abs,  stdlog_nonlin_inc_abs, nt_nl2_inc = {}, {}, {},{},{}
for i, i_shock in enumerate(df_shock_list):
    c_ss = ss_nom_ha.internals['hh']['c']
    c = irf_internals['dfshock'][i]
    D_ss = ss_nom_ha.internals['hh']['D']
    d = irf_internals_D['dfshock'][i]
    a_ss = ss_nom_ha.internals['hh']['a']
    a = irf_internals_a['dfshock'][i]
    p = irf_internals_p_pre['dfshock'][i]
    p_ss=np.transpose(np.tile(ss_nom_ha.internals['hh']['p_pretax'],(500,1))) 
    y_ss=np.transpose(np.tile(ss_nom_ha.internals['hh']['pretax'],(500,1))) 
    y = irf_internals_pre['dfshock'][i]
    r_ss=ss_nom_ha['r_ante']
    r=irf_r_post_ha['dfshock'][i]
    inc_ss=y_ss
    inc_tot_ss=y_ss+p_ss+r_ss*a_ss

    D_abs = d+D_ss
    c_abs = c+c_ss
    a_abs=a+a_ss
    r_abs=r+r_ss
    le =np.empty((100,11,500))
    pinc=np.empty((100,11,500))
    

    inc =np.empty((100,11,500))
    inc_tot=np.empty((100,11,500))
    inc2 =np.empty((100,11,500))
    inclece=np.empty((100,11,500))


    for j in range(0,T):
          
            le[j,:,:]=np.transpose(np.tile(y[j,:],(500,1)))+y_ss
            pinc[j,:,:]=np.transpose(np.tile(p[j,:],(500,1)))+p_ss
            inc2[j,:,:]=le[j,:,:]+r_abs[j-1]*a_abs[j-1,:,:]  
            inc[j,:,:]=le[j,:,:]
            inc_tot[j,:,:]=le[j,:,:]+pinc[j,:,:]+r_abs[j]*a_abs[j,:,:]
            inclece[j,:,:]=le[j,:,:]+(r_abs[j-1])*a_abs[j-1,:,:]  
           
    
    inc_vec = np.empty((5500, T))
    inc_tot_vec = np.empty((5500, T))
    D_vec = np.empty((5500, T))
    inc_sort = np.empty((5500, T))
    inc_tot_sort = np.empty((5500, T))
    D_sort = np.empty((5500, T))
    D_tot_sort = np.empty((5500, T))
    inc_log = np.empty((5500, T))
    inc_tot_log = np.empty((5500, T))
    inc_sort_log = np.empty((5500, T))
    inc_tot_sort_log = np.empty((5500, T))
    inc_sort_ihs = np.empty((5500, T))
    inc_tot_sort_ihs = np.empty((5500, T))
    weighted_std_inc = np.empty((T))
    weighted_std_inc_tot = np.empty((T))
    
    
    inc_vec_ss = inc_ss.flatten()
    inc_tot_vec_ss = inc_tot_ss.flatten()
    D_vec_ss = D_ss.flatten()
    indices = np.argsort(inc_vec_ss)
    indices_tot = np.argsort(inc_tot_vec_ss)
    inc_sort_ss = inc_vec_ss[indices]
    inc_tot_sort_ss = inc_tot_vec_ss[indices_tot]
    D_sort_ss = D_vec_ss[indices]
    D_tot_sort_ss = D_vec_ss[indices_tot]
    inc_sort_ss_log = np.log(inc_sort_ss)
    inc_tot_sort_ss_log = np.log(inc_tot_sort_ss)
    inc_sort_ss_ihs = np.arcsinh(inc_sort_ss)
    inc_tot_sort_ss_ihs = np.arcsinh(inc_tot_sort_ss)
    ss_value_sdlog_nonlin_inc = np.sqrt(np.sum(D_sort_ss * (inc_sort_ss_log - np.average(inc_sort_ss_log, weights=D_sort_ss))**2) / np.sum(D_sort_ss))
    ss_value_sdlog_nonlin_inc_tot = np.sqrt(np.sum(D_tot_sort_ss * (inc_tot_sort_ss_log - np.average(inc_tot_sort_ss_log, weights=D_tot_sort_ss))**2) / np.sum(D_tot_sort_ss))

    for j in range(0, T):

        inc_vec[:, j] = inc[j, :, :].flatten()
        inc_tot_vec[:, j] = inc_tot[j, :, :].flatten()
        D_vec[:, j] = D_abs[j, :, :].flatten()
        indices = np.argsort(inc_vec[:, j])
        indices_tot = np.argsort(inc_tot_vec[:, j])
        inc_sort[:, j] = inc_vec[:, j][indices]
        inc_tot_sort[:, j] = inc_tot_vec[:, j][indices_tot]
        D_sort[:, j] = D_vec[:, j][indices]
        D_tot_sort[:, j] = D_vec[:, j][indices_tot]
        inc_sort_log[:, j] = np.log(inc_sort[:, j])
        inc_tot_sort_log[:, j] = np.log(inc_tot_sort[:, j])
        inc_sort_ihs[:, j] = np.arcsinh(inc_sort[:, j])
        inc_tot_sort_ihs[:, j] = np.arcsinh(inc_tot_sort[:, j])
        inc_sort_log[:, j][np.isnan(inc_sort_log[:, j])] = np.nanmin(inc_sort_log[:, j])
        inc_tot_sort_log[:, j][np.isnan(inc_tot_sort_log[:, j])] = np.nanmin(inc_tot_sort_log[:, j])
        weighted_std_inc[j] = np.sqrt(np.sum(D_sort[:, j] * (inc_sort_log[:, j] - np.average(inc_sort_log[:, j], weights=D_sort[:, j]))**2) / np.sum(D_sort[:, j]))
        weighted_std_inc_tot[j] = np.sqrt(np.sum(D_tot_sort[:, j] * (inc_tot_sort_log[:, j] - np.average(inc_tot_sort_log[:, j], weights=D_tot_sort[:, j]))**2) / np.sum(D_tot_sort[:, j]))
        
      
    stdlog_nonlin_inc_abs[i]=weighted_std_inc
    stdlog_nonlin_inc_tot_abs[i]=weighted_std_inc_tot
    stdlog_nonlin_inc[i] = ((weighted_std_inc-ss_value_sdlog_nonlin_inc)/ss_value_sdlog_nonlin_inc)*100
    stdlog_nonlin_inc_tot[i] = ((weighted_std_inc_tot-ss_value_sdlog_nonlin_inc_tot)/ss_value_sdlog_nonlin_inc_tot)*100
    
  
 #%%Constant Phillips Curve Model
 
# In[3]: 

# initialize
def hh_init(a_grid, z, r, eis,dfshock,p):
    coh = (1 + r) * a_grid[np.newaxis, :] + z[:, np.newaxis]  + p[:, np.newaxis] 
    Va = (1 + r) * (coh) ** (-1 / eis)
    return Va

# backward step
@sj.het(exogenous='Pi',  # <-- this means our transition matrix will be fed into the model as Pi (use this for forward iteration)
        policy='a',  # <-- this means our endogenous state variable is a, defined over grid a_grid (we use this to check convergence)
        backward='Va',  # <-- this means we're iterating over variable Va, whose future value is Va_p (solver needs to know this to iterate!)
        backward_init=hh_init)
def hh(Va_p, a_grid, z, r, beta, eis,dfshock,Y,p):
    uc_nextgrid = beta *2.72**(dfshock)* Va_p  # u'(c') on tomorrow's grid
    c_nextgrid = uc_nextgrid ** (-eis) # c' on tomorrow's grid
    coh = (1 + r) * a_grid[np.newaxis, :] + z[:, np.newaxis] + p[:, np.newaxis] # cash on hand on today's grid
    a = sj.interpolate.interpolate_y(c_nextgrid + a_grid, coh, a_grid)  # this plots (c_next + a', a') pairs and computes policy a' from interpolation on coh
    sj.misc.setmin(a, a_grid[0])  # impose borrowing constraint
    c = coh - a  # back out consumption
    Va = (1 + r) * (c) ** (-1 / eis)  # V'(a)
    return Va, a, c,coh
    

# forward iteration is done automatically!

def income_cyclical(Y,Z,P,T,e_grid, e_pdf, zeta,zetap,markup_ss,p_grid,p_pdf):
    N =Y
    gamma_N = e_grid ** (zeta * np.log(N)) / np.vdot(e_grid ** (1 + zeta * np.log(N)), e_pdf)
    z = Z * e_grid *gamma_N
    pretax = (Y/markup_ss) * e_grid *gamma_N
    #gamma_P = p_grid ** (zetap * np.log(P/((1-T)*(1-1/markup_ss)))) / np.vdot(p_grid ** (1 + zetap * np.log(P/((1-T)*(1-1/markup_ss)))), p_pdf)
    gamma_P = p_grid ** (zetap * np.log(Y)) / np.vdot(p_grid ** (1 + zetap * np.log(Y)), p_pdf)
    p = (P)* p_grid * gamma_P
    p_pretax = (Y*(1-1/markup_ss))* p_grid * gamma_P
    return z, p, pretax, p_pretax

def make_grids_pdf(rho_e, rho_p, sd_e, sd_p, n_e, min_a, max_a, n_a):
    e_grid, e_pdf, Pi = sj.grids.markov_rouwenhorst(rho_e, sd_e, n_e)
    p_grid, p_pdf, Pi = sj.grids.markov_rouwenhorst(rho_p, sd_p, n_e)
    a_grid = sj.grids.asset_grid(min_a, max_a, n_a)
    return e_grid, e_pdf, Pi, a_grid,  p_grid, p_pdf

household_cyc = hh.add_hetinputs([make_grids_pdf, income_cyclical])

@sj.simple
def ex_post_rate(r_ante):
    r = r_ante 
    return r

@sj.simple
def fiscal(B, r, G, Y, Tr,dfshock,markup_ss):
    T = ((1 + r) * B(-1) + G - B + Tr)/(Y) # total tax burden
    Z = (Y/markup_ss)*(1 - T)  # after tax income
    P = Y*(1-1/markup_ss)*(1-T)
    deficit = G + Tr - T
    return T, Z, deficit,P

@sj.simple
def mkt_clearing_simple(A, B, Y, C, G):
    asset_mkt = A - B
    goods_mkt = Y - C - G 
    return asset_mkt, goods_mkt

ha_simple = sj.create_model([household_cyc, ex_post_rate, mkt_clearing_simple])
ha_cyc = sj.create_model([household_cyc, ex_post_rate, mkt_clearing_simple], name="HA Model with cyclical income risk")

#Economy with MP - variable kappa 

@sj.simple
def nkpc(pi, Y, yss, T, C, Z,theta_w, vphi, frisch, markup_ss, eis, beta, cpshock, curve, epsilon, phi,dfshock):
    kappa_w_base = epsilon/phi
    kappa_w = kappa_w_base*(2.72**(curve*100*(Y-yss)))
    N = Y
    W = 1/markup_ss
    piw = (1+pi) * W / W(-1) -1
    piwres= kappa_w*N*(vphi * (N)**(1/frisch)-(epsilon-1)/epsilon*C**(-1/eis)*W*(1-T)) + beta*2.72**(dfshock)*piw(1)*(1+piw(1)) - piw*(1+piw) + cpshock
    return piwres, piw, kappa_w,N,W



@sj.simple
def monetary_taylor_v(pi, Y,yss,ishock, phi_pi, phi_y,rss): 
    i=((1+rss)*(pi+1)**phi_pi*  (Y/yss)**phi_y)*2.72** ishock -1
    r_ante = (1+i) / (1+pi(1)) -1
    return i, r_ante


# We'll also define an RA model for comparison

#In[7]:


@sj.solved(unknowns={'C': 1, 'A': 1}, targets=["euler", "budget_constraint"], solver="broyden_custom")
def household_ra_simple(C, A, Y, eis, beta, r):
    euler = (beta * (1 + r(1))) ** (-eis) * C(1) - C
    budget_constraint = (1 + r) * A(-1) + Y - C - A
    return euler, budget_constraint

ra = sj.create_model([household_ra_simple, ex_post_rate, mkt_clearing_simple], name="Representative Agent Model")


ss = {}
models = {'ha': ha_simple, 'ra': ra}

print('Model Set-up done')


#%% Cyclical HANK setup

models['ha_taylor_cyc'] = sj.create_model([household_cyc, mkt_clearing_simple, nkpc,
                                        ex_post_rate, monetary_taylor_v,fiscal], name='Cyclical HA w/ Taylor Rule')

calib_taylor_cyc = calibration.copy()
calib_taylor_cyc.update({'rss': calibration['r_ante'], 'pi': 0., 'ishock': 0.,'curve':0,
                            'phi_pi': 1.5,'phi_y':0.2, 'theta_w': 0.85, 'frisch': 0.5, 'markup_ss': 1.2, 'dfshock':0,'cpshock':0, 'Tr':0.})#, 'zeta':0, 'zetap':0, 'alpha':1})

ss['ha_taylor_cyc'] = models['ha_taylor_cyc'].solve_steady_state(calib_taylor_cyc, {'beta': 0.99, 'vphi': 0.8}, ['asset_mkt', 'piwres'])

#%% Supply Shock in HANK 

import copy
irf_i_ha['dfshock_lin'],irf_Y_ha['dfshock_lin'], irf_r_post_ha['dfshock_lin'],  irf_pi_ha['dfshock_lin'], irf_kappa_ha['dfshock_lin'], irf_internals['dfshock_lin'],irf_internals_D['dfshock_lin'],irf_internals_a['dfshock_lin'],irf_internals_y['dfshock_lin'] ,irf_internals_p['dfshock_lin'],irf_internals_pre['dfshock_lin'],irf_internals_p_pre['dfshock_lin'] = {},{},{},{},{},{},{},{},{},{},{},{}
T=100
df_shock_list=[0.002, 0.0006, -0.0006, -0.002]
df_shock_test=[0]
ddf=df_shock_test * 0.9 ** np.arange(T)
piguess=ddf*0;
Yguess=ddf*0;

for i, df_shock in enumerate(df_shock_list): 
    ddf = df_shock * 0.9 ** np.arange(T)
    phi_pi=1.5
    calibration_theta = copy.deepcopy(calib_taylor_cyc)
    ss_nom_ha = models['ha_taylor_cyc'].solve_steady_state( calibration_theta, {'beta': 0.99, 'vphi': 0.8}, ['asset_mkt', 'piwres'])
    irf_here_ha = models['ha_taylor_cyc'].solve_impulse_nonlinear(ss_nom_ha, ['Y', 'pi'], ['asset_mkt', 'piwres'], {'cpshock': ddf},internals=['hh'] )
    piguess=irf_here_ha['pi'];  
    Yguess=irf_here_ha['Y']; 
    irf_i_ha['dfshock_lin'][i], irf_Y_ha['dfshock_lin'][i], irf_r_post_ha['dfshock_lin'][i] , irf_pi_ha['dfshock_lin'][i], irf_kappa_ha['dfshock_lin'][i], irf_internals['dfshock_lin'][i],irf_internals_D['dfshock_lin'][i] ,irf_internals_a['dfshock_lin'][i],irf_internals_y['dfshock_lin'][i],irf_internals_p['dfshock_lin'][i],irf_internals_pre['dfshock_lin'][i],irf_internals_p_pre['dfshock_lin'][i]=irf_here_ha["i"], irf_here_ha["Y"], irf_here_ha["r_ante"], irf_here_ha["pi"], irf_here_ha["kappa_w"], irf_here_ha.internals['hh']['c'], irf_here_ha.internals['hh']['D'] , irf_here_ha.internals['hh']['a'] , irf_here_ha.internals['hh']['z'] , irf_here_ha.internals['hh']['p'] ,irf_here_ha.internals['hh']['p_pretax'],irf_here_ha.internals['hh']['pretax']
    print('Shock Number '+ str(i+1) )
    

#%% Income Inequality 
stdlog_lin_inc,stdlog_lin_inc_tot, stdlog_lin_inc_abs, nt_nl2_inc, stdlog_lin_inc_tot_abs = {}, {}, {},{},{}
for i, i_shock in enumerate(df_shock_list):
    c_ss = ss_nom_ha.internals['hh']['c']
    c = irf_internals['dfshock_lin'][i]
    D_ss = ss_nom_ha.internals['hh']['D']
    d = irf_internals_D['dfshock_lin'][i]
    a_ss = ss_nom_ha.internals['hh']['a']
    a = irf_internals_a['dfshock_lin'][i]
    y_ss=np.transpose(np.tile(ss_nom_ha.internals['hh']['pretax'],(500,1))) #????
    y = irf_internals_pre['dfshock_lin'][i]
    p = irf_internals_p_pre['dfshock_lin'][i]
    p_ss=np.transpose(np.tile(ss_nom_ha.internals['hh']['p_pretax'],(500,1))) 
    r_ss=ss_nom_ha['r_ante']
    r=irf_r_post_ha['dfshock_lin'][i]
    inc_ss=y_ss
    inc_tot_ss=y_ss+p_ss+r_ss*a_ss
    
    
    D_abs = d+D_ss
    c_abs = c+c_ss
    a_abs=a+a_ss
    r_abs=r+r_ss
    

    le =np.empty((100,11,500))
    inc =np.empty((100,11,500))
    inc_tot=np.empty((100,11,500))
    inc2 =np.empty((100,11,500))
    inclece=np.empty((100,11,500))
    pinc=np.empty((100,11,500))


    for j in range(0,T):
            le[j,:,:]=np.transpose(np.tile(y[j,:],(500,1)))+y_ss
            pinc[j,:,:]=np.transpose(np.tile(p[j,:],(500,1)))+p_ss
            inc2[j,:,:]=le[j,:,:]+r_abs[j-1]*a_abs[j-1,:,:]  
            inc[j,:,:]=le[j,:,:]
            inc_tot[j,:,:]=le[j,:,:]+pinc[j,:,:]+r_abs[j]*a_abs[j,:,:]
            
    
    inc_vec = np.empty((5500, T))
    inc_tot_vec = np.empty((5500, T))
    D_vec = np.empty((5500, T))
    inc_sort = np.empty((5500, T))
    inc_tot_sort = np.empty((5500, T))
    D_sort = np.empty((5500, T))
    D_tot_sort = np.empty((5500, T))
    inc_log = np.empty((5500, T))
    inc_tot_log = np.empty((5500, T))
    inc_sort_log = np.empty((5500, T))
    inc_tot_sort_log = np.empty((5500, T))
    inc_sort_ihs = np.empty((5500, T))
    inc_tot_sort_ihs = np.empty((5500, T))
    weighted_std_inc = np.empty((T))
    weighted_std_inc_tot = np.empty((T))

    inc_vec_ss = inc_ss.flatten()
    inc_tot_vec_ss = inc_tot_ss.flatten()
    D_vec_ss = D_ss.flatten()
    indices = np.argsort(inc_vec_ss)
    indices_tot = np.argsort(inc_tot_vec_ss)
    inc_sort_ss = inc_vec_ss[indices]
    inc_tot_sort_ss = inc_tot_vec_ss[indices_tot]
    D_sort_ss = D_vec_ss[indices]
    D_tot_sort_ss = D_vec_ss[indices_tot]
    inc_sort_ss_log = np.log(inc_sort_ss)
    inc_tot_sort_ss_log = np.log(inc_tot_sort_ss)
    inc_sort_ss_ihs = np.arcsinh(inc_sort_ss)
    inc_tot_sort_ss_ihs = np.arcsinh(inc_tot_sort_ss)
    ss_value_sdlog_lin_inc = np.sqrt(np.sum(D_sort_ss * (inc_sort_ss_log - np.average(inc_sort_ss_log, weights=D_sort_ss))**2) / np.sum(D_sort_ss))
    ss_value_sdlog_lin_inc_tot = np.sqrt(np.sum(D_tot_sort_ss * (inc_tot_sort_ss_log - np.average(inc_tot_sort_ss_log, weights=D_tot_sort_ss))**2) / np.sum(D_tot_sort_ss))

    for j in range(0, T):

        inc_vec[:, j] = inc[j, :, :].flatten()
        inc_tot_vec[:, j] = inc_tot[j, :, :].flatten()
        D_vec[:, j] = D_abs[j, :, :].flatten()
        indices = np.argsort(inc_vec[:, j])
        indices_tot = np.argsort(inc_tot_vec[:, j])
        inc_sort[:, j] = inc_vec[:, j][indices]
        inc_tot_sort[:, j] = inc_tot_vec[:, j][indices_tot]
        D_sort[:, j] = D_vec[:, j][indices]
        D_tot_sort[:, j] = D_vec[:, j][indices_tot]
        inc_sort_log[:, j] = np.log(inc_sort[:, j])
        inc_tot_sort_log[:, j] = np.log(inc_tot_sort[:, j])
        inc_sort_ihs[:, j] = np.arcsinh(inc_sort[:, j])
        inc_tot_sort_ihs[:, j] = np.arcsinh(inc_tot_sort[:, j])
        inc_sort_log[:, j][np.isnan(inc_sort_log[:, j])] = np.nanmin(inc_sort_log[:, j])
        inc_tot_sort_log[:, j][np.isnan(inc_tot_sort_log[:, j])] = np.nanmin(inc_tot_sort_log[:, j])
        weighted_std_inc[j] = np.sqrt(np.sum(D_sort[:, j] * (inc_sort_log[:, j] - np.average(inc_sort_log[:, j], weights=D_sort[:, j]))**2) / np.sum(D_sort[:, j]))
        weighted_std_inc_tot[j] = np.sqrt(np.sum(D_tot_sort[:, j] * (inc_tot_sort_log[:, j] - np.average(inc_tot_sort_log[:, j], weights=D_tot_sort[:, j]))**2) / np.sum(D_tot_sort[:, j]))
        
           
    stdlog_lin_inc_abs[i]=weighted_std_inc
    stdlog_lin_inc_tot_abs[i]=weighted_std_inc_tot
   
    stdlog_lin_inc[i] = ((weighted_std_inc-ss_value_sdlog_lin_inc)/ss_value_sdlog_lin_inc)*100
    stdlog_lin_inc_tot[i] = ((weighted_std_inc_tot-ss_value_sdlog_lin_inc_tot)/ss_value_sdlog_lin_inc_tot)*100

#%%
from cycler import cycler
default_cycler = (cycler(color=['tab:blue', 'tab:orange', 'tab:green', 'tab:red']) +
                  cycler(linestyle=['-.', '-', ':', '--']))

plt.rc('lines', linewidth=4)
plt.rc('axes', prop_cycle=default_cycler)

#%% 

plt.rcParams.update({'font.size': 16})
fig, ((ax1, ax2),(ax3, ax4), (ax5, ax6))= plt.subplots(3, 2,sharex=False, sharey=False, figsize=(12, 16))
for i, df_shock in enumerate(df_shock_list):
    ax1.plot((400*irf_pi_ha['dfshock'][i][:40]),label=str(df_shock_list[i]) )
    ax1.set_title('Inflation')
    ax1.set( ylabel='ann. p.p. deviation from steady state')
    ax1.axhline(y=0, color='#808080', linestyle=':',linewidth=0.75)
    ax1.axis([0,25,-2.75,2.75])
    ax1.spines['right'].set_visible(False)
    ax1.spines['top'].set_visible(False)
lines, labels = ax1.get_legend_handles_labels()
custom_labels = ['large adverse shock', 'small adverse shock', 'small favorable shock', 'large favorable shock']
ax1.legend(lines, custom_labels, fontsize=11.5,handlelength=3.3, labelspacing=0.3,frameon=False)
for i, cp_shock in enumerate(df_shock_list):
    ax2.plot((400*irf_pi_ha['dfshock_lin'][i][:40]),label=str(df_shock_list[i]) )
    ax2.set_title('Inflation')
    ax2.set( ylabel='ann. p.p. deviation from steady state')
    ax2.axhline(y=0, color='#808080', linestyle=':',linewidth=0.75)
    ax2.axis([0,25,-2.75,2.75])
    ax2.spines['right'].set_visible(False)
    ax2.spines['top'].set_visible(False)
for i, cp_shock in enumerate(df_shock_list):
    ax3.plot((100*irf_Y_ha['dfshock'][i][:40]),label=str(df_shock_list[i]) )
    ax3.set_title('Output')
    ax3.set(ylabel='percent deviation from steady state')
    ax3.axhline(y=0, color='#808080', linestyle=':',linewidth=0.75)
    ax3.axis([0,25,-2.6,2.6])
    ax3.spines['right'].set_visible(False)
    ax3.spines['top'].set_visible(False)  
for i, cp_shock in enumerate(df_shock_list):
    ax4.plot((100*irf_Y_ha['dfshock_lin'][i][:40]),label=str(df_shock_list[i]) )
    ax4.set_title('Output')
    ax4.set(ylabel='percent deviation from steady state')  
    ax4.axhline(y=0, color='#808080', linestyle=':',linewidth=0.75)
    ax4.axis([0,25,-2.6,2.6])
    ax4.spines['right'].set_visible(False)
    ax4.spines['top'].set_visible(False)
for i, cp_shock in enumerate(df_shock_list):
    ax5.plot((stdlog_nonlin_inc_tot[i][:40]),label=str(df_shock_list[i])  )
    ax5.set_title('Income Inequality')
    ax5.set(xlabel='quarters', ylabel='percent deviation from steady state')
    ax5.axhline(y=0, color='#808080', linestyle=':',linewidth=0.75)
    ax5.axis([0,25,-15,15])
    ax5.spines['right'].set_visible(False)
    ax5.spines['top'].set_visible(False)
for i, cp_shock in enumerate(df_shock_list):
    ax6.plot((stdlog_lin_inc_tot[i][:40]),label=str(df_shock_list[i])  )
    ax6.set_title('Income Inequality')
    ax6.set(xlabel='quarters', ylabel='percent deviation from steady state')
    ax6.axhline(y=0, color='#808080', linestyle=':',linewidth=0.75)
    ax6.axis([0,25,-15,15])
    ax6.spines['right'].set_visible(False)
    ax6.spines['top'].set_visible(False)
plt.figtext(0.06, 1, r'State-dependent Phillips curve slope', fontsize=20, fontweight='bold')  
plt.figtext(0.6, 1, r'Constant Phillips curve slope', fontsize=20, fontweight='bold') 
plt.figtext(0.06, 1, r'State-dependent Phillips curve slope', fontsize=20, fontweight='bold')  
plt.figtext(0.6, 1, r'Constant Phillips curve slope', fontsize=20, fontweight='bold') 
plt.tight_layout()
plt.show()


