clear all;
close all;
clc;

%% Inflation & GDP Data 

%Raw Sample: 1967Q1 thru 2019Q4

rawtime=1967.0:0.25:2019.75;

timestart=1967.0;
timeend=2019.75;%2007.75;%2018.75;

time=timestart:0.25:timeend;
time_idx=find(rawtime==timestart):find(rawtime==timeend);


% Inflation, quarterly frequency, quarterly changes at annual rate	
% 	
% FRED Graph Observations	
% Federal Reserve Economic Data	
% Link: https://fred.stlouisfed.org	
% Help: https://fredhelp.stlouisfed.org	
% Economic Research Division	
% Federal Reserve Bank of St. Louis	
% 	
% DPCCRV1Q225SBEA	Personal Consumption Expenditures (PCE) Excluding Food and Energy (chain-type price index), Percent Change from Preceding Period, Quarterly, Seasonally Adjusted Annual Rate
	
infl=[2.2
2.7
3.7
4.1
4.6
4.7
4.5
4.7
4.4
4.9
4.7
4.8
4.4
4.6
4.5
5.8
5.2
4.6
3.8
2.3
3.9
2.7
3.0
2.5
2.8
5.6
5.4
5.7
7.0
10.3
11.9
10.1
8.1
6.2
6.1
6.7
6.2
4.9
6.4
6.4
6.9
6.3
6.8
5.9
6.4
7.1
7.0
7.4
5.6
9.1
7.6
8.6
10.2
9.2
9.2
10.1
9.2
7.8
7.6
7.3
6.0
5.5
6.6
5.7
5.4
3.1
6.2
3.2
4.1
4.8
3.8
2.9
5.6
3.5
4.2
2.9
4.4
2.8
2.8
3.3
2.6
3.9
3.6
4.1
3.9
4.9
4.7
4.5
4.4
3.7
3.0
3.7
4.7
4.5
4.1
3.4
3.6
3.1
3.6
3.2
3.1
2.9
2.4
3.0
2.8
3.1
2.3
2.1
1.8
2.7
2.3
2.0
2.1
2.4
1.9
2.0
1.6
1.9
1.8
2.3
1.6
2.1
0.9
1.3
1.2
1.2
1.4
1.3
1.0
1.4
1.5
1.9
2.1
1.4
1.9
2.0
2.6
1.5
1.0
1.9
1.2
2.2
2.1
1.4
1.2
1.5
1.8
1.8
2.2
2.3
1.4
2.2
2.9
2.0
1.6
2.7
2.3
3.2
2.2
1.7
2.8
1.7
2.0
2.8
2.1
1.7
2.1
-0.3
0.0
1.6
1.4
2.5
1.4
1.1
0.6
1.3
1.8
2.4
1.8
1.4
2.5
1.7
1.2
1.8
1.6
1.1
1.6
1.7
1.3
1.8
1.5
1.1
0.7
1.8
1.3
1.0
1.7
2.2
1.7
1.4
1.9
1.3
1.2
1.8
2.6
2.2
1.3
1.9
1.6
1.7
1.5
1.4
];


% FRED Graph Observations		
% Federal Reserve Economic Data, Federal Reserve Bank of St. Louis		
% Link: https://fred.stlouisfed.org		
% Help: https://fredhelp.stlouisfed.org		
% This data may be copyrighted. Please refer to the Terms of Use: https://fred.stlouisfed.org/legal#fred-terms-faq		
% File Created: 2025-05-02 9:36 am CDT		
% 
% GDPC1_PCH	Real Gross Domestic Product, Percent Change, Quarterly, Seasonally Adjusted Annual Rate	Data Updated: 2025-04-30


dy=[0.88579
0.06135
0.94608
0.75385
2.03927
1.67037
0.77452
0.39277
1.56443
0.30335
0.65995
-0.48821
-0.14889
0.14172
0.92147
-1.07157
2.71615
0.54082
0.82245
0.23486
1.83722
2.26929
0.94409
1.67444
2.47494
1.08874
-0.52584
0.94923
-0.85971
0.23770
-0.94528
-0.38841
-1.21763
0.71470
1.71204
1.34709
2.24947
0.73337
0.54741
0.72260
1.18623
1.94192
1.80316
0.00199
0.31984
3.86477
1.00575
1.34413
0.17959
0.10675
0.74280
0.25005
0.31457
-2.06043
-0.11885
1.86492
1.95942
-0.74108
1.19750
-1.08960
-1.55364
0.45618
-0.38227
0.04001
1.31779
2.27552
1.99895
2.08618
1.95479
1.72776
0.96401
0.82077
0.96898
0.88047
1.52727
0.74345
0.93375
0.45030
0.95667
0.53639
0.74184
1.07818
0.86718
1.71696
0.51688
1.31403
0.58597
1.33246
1.01639
0.76310
0.74074
0.19698
1.09288
0.36297
0.06658
-0.91040
-0.46794
0.77969
0.50536
0.34854
1.19725
1.08430
0.98811
1.04286
0.16694
0.58217
0.47715
1.36015
0.97036
1.35518
0.58458
1.14557
0.35478
0.29832
0.85073
0.67908
0.74905
1.66794
0.89703
1.03837
0.64544
1.66522
1.24857
0.85386
1.00375
0.92569
1.25894
1.60920
0.93943
0.83474
1.32588
1.64067
0.36279
1.82129
0.10193
0.59704
-0.32780
0.62450
-0.40064
0.27478
0.83636
0.61271
0.40651
0.12361
0.52664
0.88562
1.66320
1.16072
0.56665
0.77495
0.94859
1.02021
1.10936
0.49262
0.78381
0.55552
1.34538
0.25875
0.14996
0.85945
0.30084
0.61176
0.57603
0.62824
-0.42676
0.59543
-0.52526
-2.18903
-1.13487
-0.17865
0.35119
1.08091
0.48450
0.96759
0.77108
0.52511
-0.23720
0.67658
-0.02231
1.12305
0.83859
0.44633
0.14403
0.11564
0.98656
0.26764
0.85139
0.87174
-0.34510
1.29184
1.21539
0.50573
0.90048
0.61941
0.40025
0.18448
0.57952
0.32112
0.70939
0.55430
0.48689
0.55987
0.78852
1.12705
0.81341
0.53083
0.62370
0.14164
0.62432
0.83515
1.17000
0.68188
];

% Annualize data
dy=dy*4;

%% Plot Data

% Define NBER recession periods 
recession_periods = [1969.92, 1970.84;
                     1973.84, 1975.17;
                     1980, 1980.5;
                     1981.5, 1982.84;
                     1990.5, 1991.17;
                     2001.17, 2001.84;
                     2007.92, 2009.5];

% Compute skewness for Inflation and GDP Growth
skewness_infl = skewness(infl);
skewness_dy = skewness(dy);

% Create figure
figure;

% ---- First subplot: Inflation ----
subplot(1,2,1)
hold on;
% Add recession bands with quarterly precision
h_fill = gobjects(size(recession_periods,1),1); % Pre-allocate handles for legend
for i = 1:size(recession_periods,1)
    x = [recession_periods(i,1), recession_periods(i,2)];
    ylims = [-1, 12]; % Keep y-axis limits consistent
    h_fill(i) = fill([x(1) x(2) x(2) x(1)], [ylims(1) ylims(1) ylims(2) ylims(2)], ...
         [0.8 0.8 0.8], 'EdgeColor', 'none', 'FaceAlpha', 0.5);
end
% Plot Inflation
h_line1 = plot(time, infl, 'LineWidth', 3);
yline(0, '--k', 'LineWidth', 2);
ylabel('%');
box off;
title('Inflation (qoq, annualized)', 'FontSize', 26);
axis([time(1) time(end) -1 12]);
fontsize(gca, 26, 'points');

% Add skewness text box for Inflation
text(time(end) - 30, 10, sprintf('Skewness = %.2f', skewness_infl), ...
    'FontSize', 20, 'BackgroundColor', 'w', 'EdgeColor', 'k');

% ---- Second subplot: GDP Growth ----
subplot(1,2,2)
hold on;
% Add recession bands with quarterly precision
for i = 1:size(recession_periods,1)
    x = [recession_periods(i,1), recession_periods(i,2)];
    ylims = [-10, 16]; % Keep y-axis limits consistent
    fill([x(1) x(2) x(2) x(1)], [ylims(1) ylims(1) ylims(2) ylims(2)], ...
         [0.8 0.8 0.8], 'EdgeColor', 'none', 'FaceAlpha', 0.5);
end
% Plot GDP Growth
h_line2 = plot(time, dy, 'LineWidth', 3);
yline(0, '--k', 'LineWidth', 2);
ylabel('%');
box off;
title('GDP Growth (qoq, annualized)', 'FontSize', 26);
axis([time(1) time(end) -10 16]);
fontsize(gca, 26, 'points');

% Add skewness text box for GDP Growth
text(time(end) - 30, 12, sprintf('Skewness = %.2f', skewness_dy), ...
    'FontSize', 20, 'BackgroundColor', 'w', 'EdgeColor', 'k');

% ---- Add a Shared Legend at the Bottom (No Box) ----
leg = legend([h_line1, h_fill(1)], {'Data', 'NBER Recessions'}, ...
               'Position',[0.0104 0.894 1.021 0.170],...
    'Orientation','horizontal');
leg.Box = 'off';
leg.FontSize = 26; % Adjust font size
hold off;


