kap=0.05;
chi=50;
ybar=1;

%y_grid=0.96:0.01:1.03;
%y_grid=0.92:0.01:1.08;
y_grid=0.90:0.001:1.05; %bounds correspond to CBO output gap
kappa=kap*exp(chi*(y_grid-ybar));

% figure;
% subplot(1,2,1)
% plot(y_grid,kappa);hold on; plot(y_grid,kappa*0+kap);
% title('kappa - level');
% subplot(1,2,2)
% plot((y_grid-ybar)/ybar*100,(kappa-kap)/kap*100); hold on;plot((y_grid-ybar)/ybar*100,0*(kappa-kap)/kap*100);
% title('kappa - deviations');


figure;
plot((y_grid-ybar)/ybar*100,kappa,'r-','LineWidth',2);hold on; plot((y_grid-ybar)/ybar*100,kappa*0+kap,'b--','LineWidth',2);
xlabel('Output Gap (%)','FontSize',26);
ylabel('\kappa_t','FontSize',26);
legend('State-dependent Phillips Curve slope (\chi = 50)','Constant Phillips Curve slope (\chi = 0)','FontSize',26,'Location','NorthWest');
legend boxoff;
box off;
set(gca,'FontSize',26);
axis([-7 3 0 0.25]);
orient landscape
print -dpdf -fillpage kappa_plot